<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/common.css" media="screen,print" charset="utf-8" type="text/css" />

		<script type="text/javascript" src="../js/jquery.js" charset="utf-8"></script>
	</head>
	<body id="categoryDetail">
		<div id="content">
			<xsl:for-each select="header/section">
				<div class="{@style}">
					<xsl:for-each select="line">
						<xsl:value-of select="@title"/><xsl:value-of select="@string"/><br/>
					</xsl:for-each>
				</div>
			</xsl:for-each>
			<div id="contentBody">
				<xsl:apply-templates select="currencies/currency"/>
			</div>
			<div id="summary">
				<xsl:for-each select="totals/total">
					<div class="header">
						<xsl:value-of select="@title"/><xsl:value-of select="@amount"/>
					</div>
				</xsl:for-each>
			</div>
		</div>
	</body>
	</html>
</xsl:template>


<xsl:template match="currency">
	<xsl:if test="count(../currency) > 1">
		<div class="currency"><xsl:value-of select="@title"/></div>
	</xsl:if>
	
	<xsl:apply-templates select="hierarchies/hierarchy"/>
</xsl:template>


<xsl:template match="hierarchy">
	<div class="hierarchy">
		<div class="header">
			<span class="name"><xsl:value-of select="@name"/></span> (<span class="total"><xsl:value-of select="total"/></span>)
		</div>

		<table class="transactionDetail">
			<thead><tr>
				<xsl:for-each select="/root/columns/column">
					<xsl:variable name="index" select="position()"/>
					<th style="width: {@widthPercentage}%; text-align: {@alignment};"><xsl:value-of select="@title"/></th>
				</xsl:for-each>
			</tr></thead>
			<tbody>
				<xsl:for-each select="transaction">
					<tr>
						<xsl:for-each select="*">
							<xsl:variable name="index" select="position()"/>
							<td style="text-align: {../../../../../../columns/column[$index]/@alignment}; white-space: {../../../../../../columns/column[$index]/@whiteSpace};"><xsl:value-of select="."/></td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</div>
</xsl:template>

</xsl:stylesheet>